/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm2210;

import ibm.nways.jdm.GraphicActionNavigate;
import ibm.nways.jdm.GraphicComponent;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicHelp;
import ibm.nways.jdm.GraphicImage;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.HelpRef;
import ibm.nways.jdm.I18NString;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.JdmLayout;
import ibm.nways.jdm.Log;
import ibm.nways.jdm.NavInitialRow;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.RemoteStatus;
import ibm.nways.jdm.StatusProxy;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm2210.AtmSlot;
import ibm.nways.jdm2210.EthernetImageGroup;
import ibm.nways.jdm2210.FeatureSlotImage;
import ibm.nways.jdm2210.IsdnBriSlot;
import ibm.nways.jdm2210.IsdnPriE1Slot;
import ibm.nways.jdm2210.IsdnPriT1Slot;
import ibm.nways.jdm2210.TokenRingImageGroup;
import ibm.nways.jdm2210.Wan4PortSlot;
import ibm.nways.jdm2210.Wan8PortSlot;
import ibm.nways.jdm2210.WanDualMount;
import java.awt.Point;
import java.io.Serializable;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class Box24XGraphic {
    private GenModel jdm2210Model;
    private boolean isLogging = false;
    private GenModel systemModel;
    private GenModel interface2210Model;
    private JdmBrowser jdm2210Browser;
    private Vector modelList;
    private Vector remoteStatusList;
    private Vector proxyStatusList;
    private Vector pcmcia_Info = new Vector();
    private Vector interfaceInfo;
    private int boxType;
    private int featureSlot;
    private Point boxPoint = new Point(20, 20);
    private Point featurePoint = new Point(242, 33);
    private static final String PropertiesFile = "properties/jdm2210.txt";
    private static final String layoutKey = "box.layout.scheme";
    private static final String fractKey = "box.layout.fractions";
    static final String HelpRef_Dir = "ibm.nways.jdm2210";
    static final String HelpRef_2210html = "ibm.nways.jdm2210.BoxGraphic.html";

    protected Box24XGraphic(JdmBrowser jdmBrowser, int n, int n2) {
        if (jdmBrowser.getIsApplication()) {
            this.isLogging = Log.getLog().getLoggingState();
        }
        this.modelList = new Vector();
        this.remoteStatusList = new Vector();
        this.proxyStatusList = new Vector();
        this.jdm2210Browser = jdmBrowser;
        this.boxType = n;
        this.featureSlot = n2;
    }

    protected GraphicPanel getGraphicPanel() {
        int n;
        Object object;
        Object object2;
        Properties properties;
        Serializable serializable;
        GraphicContainer graphicContainer = new GraphicContainer();
        try {
            serializable = new URL(this.jdm2210Browser.getDocumentBase(), PropertiesFile);
            if (this.isLogging) {
                System.out.println("DocumentBase = " + this.jdm2210Browser.getDocumentBase());
            }
            properties = new Properties();
            properties.load(((URL)serializable).openStream());
        }
        catch (Exception exception) {
            System.out.println("Error getting Jdm2210 Properties: " + exception.getMessage());
            properties = null;
            exception.printStackTrace();
        }
        JdmLayout jdmLayout = (JdmLayout)this.jdm2210Browser.getLayout();
        if (properties != null) {
            serializable = new Integer((String)((Hashtable)properties).get(layoutKey));
            if (this.isLogging) {
                System.out.println("The layout scheme property = " + serializable);
            }
            int n2 = (Integer)serializable;
            jdmLayout.setScheme(n2);
            object2 = (String)((Hashtable)properties).get(fractKey);
            object = new StringTokenizer((String)object2);
            float[] fArray = new float[((StringTokenizer)object).countTokens()];
            n = 1;
            int n3 = 0;
            while (n3 < fArray.length && ((StringTokenizer)object).hasMoreTokens()) {
                String string = ((StringTokenizer)object).nextToken();
                try {
                    fArray[n3] = Float.valueOf(string).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Bad layout.fractions parm(" + numberFormatException.getMessage() + ")");
                    n = 0;
                }
                ++n3;
            }
            if (n != 0) {
                jdmLayout.setFracts(fArray);
            }
        }
        this.getBoxInfo();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("ibm.nways.jdm2210.Resources");
        GraphicImage graphicImage = new GraphicImage(this.jdm2210Browser.imageFrom(this, "box24X.gif"), this.boxPoint, 3, new GraphicActionNavigate(this.jdm2210Browser, new NavigationDestination("ibm.nways.mib2.eui.SystemPanel", this.systemModel), null), null);
        graphicContainer.add(graphicImage);
        serializable = new GraphicHelp(this.jdm2210Browser, new Point(0, 0), new HelpRef(HelpRef_Dir, HelpRef_2210html));
        graphicContainer.add((GraphicComponent)serializable);
        int n4 = 274;
        n = 92;
        if (this.boxType == 10) {
            object = new EthernetImageGroup(this.jdm2210Browser, new Point(this.boxPoint.x + n4, this.boxPoint.y + n), 0, 1);
            this.attachStatusAndAction(this.interface2210Model, ((EthernetImageGroup)object).getGrImage(), 0, ((EthernetImageGroup)object).getI18NName());
            graphicContainer.add((GraphicContainer)object);
            object = new EthernetImageGroup(this.jdm2210Browser, new Point(this.boxPoint.x + 459, this.boxPoint.y + n), 0, 2);
            this.attachStatusAndAction(this.interface2210Model, ((EthernetImageGroup)object).getGrImage(), 5, ((EthernetImageGroup)object).getI18NName());
            graphicContainer.add((GraphicContainer)object);
        } else if (this.boxType == 11) {
            object = new EthernetImageGroup(this.jdm2210Browser, new Point(this.boxPoint.x + n4, this.boxPoint.y + n), 0);
            this.attachStatusAndAction(this.interface2210Model, ((EthernetImageGroup)object).getGrImage(), 0, ((EthernetImageGroup)object).getI18NName());
            graphicContainer.add((GraphicContainer)object);
            object2 = new TokenRingImageGroup(this.jdm2210Browser, new Point(this.boxPoint.x + 459, this.boxPoint.y + n), 0);
            this.attachStatusAndAction(this.interface2210Model, ((TokenRingImageGroup)object2).getGrImage(), 5, ((TokenRingImageGroup)object2).getI18NName());
            graphicContainer.add((GraphicContainer)object2);
        } else if (this.boxType == 12) {
            object2 = new TokenRingImageGroup(this.jdm2210Browser, new Point(this.boxPoint.x + n4, this.boxPoint.y + n), 0, 1);
            this.attachStatusAndAction(this.interface2210Model, ((TokenRingImageGroup)object2).getGrImage(), 0, ((TokenRingImageGroup)object2).getI18NName());
            graphicContainer.add((GraphicContainer)object2);
            object2 = new TokenRingImageGroup(this.jdm2210Browser, new Point(this.boxPoint.x + 459, this.boxPoint.y + n), 0, 2);
            this.attachStatusAndAction(this.interface2210Model, ((TokenRingImageGroup)object2).getGrImage(), 5, ((TokenRingImageGroup)object2).getI18NName());
            graphicContainer.add((GraphicContainer)object2);
        } else if (this.boxType == 13) {
            object2 = new TokenRingImageGroup(this.jdm2210Browser, new Point(this.boxPoint.x + n4, this.boxPoint.y + n), 0);
            this.attachStatusAndAction(this.interface2210Model, ((TokenRingImageGroup)object2).getGrImage(), 0, ((TokenRingImageGroup)object2).getI18NName());
            graphicContainer.add((GraphicContainer)object2);
        }
        WanDualMount wanDualMount = new WanDualMount(this.jdm2210Browser, new Point(this.boxPoint.x + 197, this.boxPoint.y + 89), 0, 1);
        this.attachStatusAndAction(this.interface2210Model, wanDualMount.getPort(0), 1, wanDualMount.getI18NName(0));
        this.attachStatusAndAction(this.interface2210Model, wanDualMount.getPort(1), 2, wanDualMount.getI18NName(1));
        graphicContainer.add(wanDualMount);
        wanDualMount = new WanDualMount(this.jdm2210Browser, new Point(this.boxPoint.x + 386, this.boxPoint.y + 89), 0, 3);
        this.attachStatusAndAction(this.interface2210Model, wanDualMount.getPort(0), 3, wanDualMount.getI18NName(0));
        this.attachStatusAndAction(this.interface2210Model, wanDualMount.getPort(1), 4, wanDualMount.getI18NName(1));
        graphicContainer.add(wanDualMount);
        this.addFeatureSlot(graphicContainer, 6);
        GraphicPanel graphicPanel = new GraphicPanel(this.jdm2210Browser, graphicContainer);
        return graphicPanel;
    }

    private void addFeatureSlot(GraphicContainer graphicContainer, int n) {
        FeatureSlotImage featureSlotImage = this.createFeatureSlot(this.featureSlot, new Point(this.featurePoint.x + this.boxPoint.x, this.featurePoint.y + this.boxPoint.y));
        if (featureSlotImage != null) {
            GraphicImage graphicImage;
            int n2 = 0;
            while ((graphicImage = featureSlotImage.getPort(n2)) != null) {
                this.attachStatusAndAction(this.interface2210Model, graphicImage, n++, featureSlotImage.getI18NName(n2));
                ++n2;
            }
            graphicContainer.add(featureSlotImage);
        }
    }

    private void getBoxInfo() {
        if (this.systemModel == null) {
            try {
                this.systemModel = (GenModel)this.jdm2210Model.getComponent("System");
                if (this.isLogging) {
                    System.out.println("Got system2 model");
                }
            }
            catch (Exception exception) {
                System.out.println("Exception getting system2 model.");
            }
        }
        if (this.interface2210Model == null) {
            try {
                this.interface2210Model = (GenModel)this.jdm2210Model.getComponent("Interface");
                if (this.isLogging) {
                    System.out.println("Got interface model");
                    return;
                }
            }
            catch (Exception exception) {
                System.out.println("Exception getting Graphic Interface Model");
                return;
            }
        }
    }

    protected void setJdm2210Model(GenModel genModel) {
        this.jdm2210Model = genModel;
    }

    protected void setSystemModel(GenModel genModel) {
        this.systemModel = genModel;
    }

    void attachStatusAndAction(GenModel genModel, GraphicImage graphicImage, int n, I18NString i18NString) {
        if (this.interfaceInfo == null) {
            try {
                this.interfaceInfo = genModel.getRestOfInfo("_Empty", "default", null, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            NavigationContext navigationContext = new NavigationContext();
            ModelInfo modelInfo = (ModelInfo)this.interfaceInfo.elementAt(n);
            NavInitialRow.setInitialRow(navigationContext, modelInfo);
            navigationContext.setParent(this.jdm2210Browser.getNavigationTree().getNavContext());
            RemoteStatus remoteStatus = genModel.getStatusRefForRow(modelInfo);
            StatusProxy statusProxy = new StatusProxy(remoteStatus);
            GraphicActionNavigate graphicActionNavigate = new GraphicActionNavigate(this.jdm2210Browser, new NavigationDestination("ibm.nways.mib2.eui.Mib2InterfacesPanel", genModel), navigationContext);
            statusProxy.setName(i18NString);
            graphicImage.setStatus(statusProxy);
            graphicImage.setAction(graphicActionNavigate);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private FeatureSlotImage createFeatureSlot(int n, Point point) {
        switch (n) {
            case 1: {
                return null;
            }
            case 2: {
                return new IsdnBriSlot(this.jdm2210Browser, point, 0);
            }
            case 4: {
                return new IsdnPriE1Slot(this.jdm2210Browser, point, 0);
            }
            case 5: {
                return new IsdnPriT1Slot(this.jdm2210Browser, point, 0);
            }
            case 6: 
            case 7: {
                return new AtmSlot(this.jdm2210Browser, point, 0);
            }
            case 8: {
                return new Wan4PortSlot(this.jdm2210Browser, point, 0);
            }
            case 9: {
                return new Wan8PortSlot(this.jdm2210Browser, point, 0);
            }
        }
        return null;
    }
}

